/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.ChangeMgmtInfo;
import com.ibm.hwmca.base.updates.ConsoleSingleStepMclBean;
import com.ibm.hwmca.base.updates.ConsoleSingleStepMclConstants;
import com.ibm.hwmca.base.updates.SingleStepEvent;
import com.ibm.hwmca.base.updates.SingleStepListener;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaServicesBusyInterface;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.report.DurationReport;
import com.ibm.hwmca.fw.report.StepReport;
import com.ibm.hwmca.fw.system.RestartManager;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;

public class ConsoleSingleStepMclTasklet
extends HwmcaPanelTasklet
implements CommonMsgInterface,
ProgressEndedListener,
ProgressCancelListener,
SingleStepListener,
ConsoleSingleStepMclConstants,
UpdatesErrorIds,
MediaServicesBusyInterface {
    private static final String TRACE_MASKT = "XCMZCSTT";
    private static final String TRACE_MASKF = "XCMZCSTF";
    private static final String TRACE_MASKD = "XCMZCSTD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(2, "HMC SSMclTsk");
    private static final String AUIML_RESOURCE_NAME = "com.ibm.hwmca.base.updates.res.ConsoleSingleStepMclRes";
    private static final String PANEL_NAME_SELECT = "ConsoleSingleStepMclPanel";
    private static final String RESTART_CLASS = "com.ibm.hwmca.base.updates.ConsoleSingleStepMclRestartTasklet";
    private static final int RETRIEVE = 0;
    private static final int APPLY = 1;
    private static final int REMOVE = 2;
    private static final int DEFAULT_OPERATION = 0;
    private static final String[] SELECTION_NAME = new String[]{"RetrieveChoice", "ApplyChoice", "RemoveChoice"};
    private static final String[] progressPanelStartMsg = new String[]{"updates.ssm.progress.startRetrieveAndApply", "updates.ssm.progress.startApply", "updates.ssm.progress.startRemove"};
    private static final String[] confirmTitle = new String[]{"SSM08000", "SSM08001", "SSM08002"};
    private static final String[] confirmMsg = new String[]{"SSM01900", "SSM01901", "SSM01902"};
    private static final String[] confirmButtons = new String[]{"updates.ssm.button.retrieveAndApply", "updates.ssm.button.apply", "updates.ssm.button.remove"};
    private static final int[] utilitiesOperation = new int[]{0, 1, 2};
    private boolean progressDismissed = false;
    private Object progressGate = new Object();
    private boolean progressCanceled = false;
    private UpdateUtilities myUU = new UpdateUtilities();
    private ProgressReportListenerImpl reportListener;
    private int operation = 0;
    private boolean isBusyDesiredForMediaOperations = true;
    LocalizableText busyMessage = null;

    public ConsoleSingleStepMclTasklet() {
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.()");
        this.setExplicitTerminate(true);
        Trace.trace(TRACE_MASKT, "<- ConsoleSingleStepMclTasklet.()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.logException()");
        new FrameworkLog(logInfo, -6910, throwable).log();
        Trace.trace(TRACE_MASKT, "<- ConsoleSingleStepMclTasklet.logException()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.service()");
        if (request.isInitialRequest()) {
            ConsoleSingleStepMclBean bean = new ConsoleSingleStepMclBean();
            bean.setBeanName("function");
            String[] selected = new String[]{SELECTION_NAME[this.operation]};
            bean.setRetrieveApplyRemoveGBSelection(selected);
            response.replace(AUIML_RESOURCE_NAME, PANEL_NAME_SELECT, bean);
        } else if (request.isDisposed() || request.isCanceled()) {
            String panel = (String)request.getData("panel");
            Trace.trace(TRACE_MASKF, "   ConsoleSingleStepMclTasklet.service() disposing panel = \"" + panel + "\"");
            if (panel.equals("function")) {
                response.terminate();
            } else {
                response.dispose();
            }
        } else {
            String panel = (String)request.getData("panel");
            Trace.trace(TRACE_MASKF, "   ConsoleSingleStepMclTasklet.service() panel = \"" + panel + "\"");
            if (panel.equals("restart")) {
                this.progressDismissed = false;
                this.reportListener = null;
                this.progressCanceled = false;
                ConsoleSingleStepMclBean bean = new ConsoleSingleStepMclBean();
                bean.setBeanName("function");
                bean.setRetrieveApplyRemoveGBSelection(new String[]{SELECTION_NAME[this.operation]});
                response.replace(AUIML_RESOURCE_NAME, PANEL_NAME_SELECT, bean);
            } else if (panel.equals("function")) {
                TaskActionEvent event = (TaskActionEvent)request.getData("event");
                String selection = (String)request.getData("choice");
                Trace.trace(TRACE_MASKF, "   ConsoleSingleStepMclTasklet.service() event = \"" + event + "\"" + " selection = \"" + selection + "\"");
                if (selection.equals(SELECTION_NAME[0])) {
                    this.operation = 0;
                } else if (selection.equals(SELECTION_NAME[1])) {
                    this.operation = 1;
                } else if (selection.equals(SELECTION_NAME[2])) {
                    this.operation = 2;
                }
                this.doOperation(request, response);
            } else {
                throw new TaskletException("Unknown source panel - " + panel);
            }
        }
        Trace.trace(TRACE_MASKT, "<- ConsoleSingleStepMclTasklet.service()");
    }

    private void doOperation(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        boolean confirmed;
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.doOperation() - Operation = " + this.operation);
        if (!this.checkChangeManagementEnabled()) {
            Trace.trace(TRACE_MASKF, "<- ConsoleSingleStepMclTasklet.doOperation() - Change Management is disabled");
            response.noAction();
            return;
        }
        if (!this.isRsfAvailable()) {
            Trace.trace(TRACE_MASKF, "<- ConsoleSingleStepMclTasklet.doOperation() - RSF is not available, operation is " + this.operation);
            response.noAction();
            return;
        }
        String noRwCdString = System.getProperty("NO_RW_CD", "FALSE");
        boolean haveRwCd = true;
        if (noRwCdString.equalsIgnoreCase("TRUE")) {
            haveRwCd = false;
        }
        if (haveRwCd && 2 != this.operation) {
            MediaServicesUtil myMSU = new MediaServicesUtil(this);
            LocalizableText whoIam = new LocalizableText(BaseTextBundle.getBundleName(), "updates.ssm.mediaServices.myName");
            try {
                myMSU.prepareMedia(6, whoIam, true, "ACTBKP");
            }
            catch (MediaServicesUtilException msue) {
                Trace.trace(TRACE_MASKF, "<- ConsoleSingleStepMclTasklet.doOperation() - media not available");
                response.noAction();
                return;
            }
            try {
                myMSU.releaseMedia();
            }
            catch (MediaServicesUtilException msue) {
                Trace.trace(TRACE_MASKF, "<- ConsoleSingleStepMclTasklet.doOperation() - release media error");
                response.noAction();
                return;
            }
        }
        if (!(confirmed = this.confirmOperation())) {
            response.noAction();
            Trace.trace(TRACE_MASKT, "<- ConsoleSingleStepMclTasklet.doOperation() - confirmation negative");
            return;
        }
        Runnable progRun = new Runnable(){

            public void run() {
                Trace.trace(ConsoleSingleStepMclTasklet.TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.progRun.run()");
                ConsoleSingleStepMclTasklet.this.startOperation();
                Trace.trace(ConsoleSingleStepMclTasklet.TRACE_MASKT, "<- ConsoleSingleStepMclTasklet.progRun.run()");
            }
        };
        Thread progThread = new Thread(progRun, "ConsoleSingleStepMclTasklet");
        progThread.start();
        response.dispose("function");
        Trace.trace(TRACE_MASKF, "<- ConsoleSingleStepMclTasklet.doOperation()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startOperation() {
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.startOperation() - Operation = " + this.operation);
        String id = "1";
        int duration = this.myUU.getSingleStepTotalDuration(utilitiesOperation[this.operation], false, true);
        Trace.trace(TRACE_MASKF, "   ConsoleSingleStepMclTasklet.startOperation() - about to start the requested operation");
        LocalizableText initialText = new LocalizableText(BaseTextBundle.getBundleName(), progressPanelStartMsg[this.operation]);
        ProgressData progData = new ProgressData(initialText, duration, 0);
        PanelTaskletProgressListener progListener = new PanelTaskletProgressListener(this);
        ProgressStartEvent start = new ProgressStartEvent(this.getTask().getUIInfo().getUnlocalizedName(), new ProgressData[]{progData}, (long)duration, initialText, id, (ProgressCancelListener)this, (ProgressEndedListener)this);
        progListener.startProgress(start);
        this.reportListener = new ProgressReportListenerImpl(id, null, progListener);
        Trace.trace(TRACE_MASKF, "   ConsoleSingleStepMclTasklet.startOperation() - waiting for the progress window to be dismissed");
        this.myUU.singleStep(utilitiesOperation[this.operation], this, false, false);
        Object object = this.progressGate;
        synchronized (object) {
            this.progressDismissed = false;
            while (!this.progressDismissed) {
                try {
                    Trace.trace(TRACE_MASKF, "   ConsoleSingleStepMclTasklet.startOperation() - entering wait()");
                    this.progressGate.wait();
                    Trace.trace(TRACE_MASKF, "   ConsoleSingleStepMclTasklet.startOperation() - leaving wait()");
                }
                catch (InterruptedException exc) {}
            }
        }
        Trace.trace(TRACE_MASKF, "   ConsoleSingleStepMclTasklet.startOperation() - progress window has been dismissed");
        PanelTaskletRequest restart = new PanelTaskletRequest();
        restart.setData("panel", "restart");
        restart.setData("event", null);
        restart.setData("choice", "");
        try {
            this.postRequest(null, restart);
        }
        catch (TaskletException te) {
            this.logException(te);
        }
        Trace.trace(TRACE_MASKF, "<- ConsoleSingleStepMclTasklet.startOperation()");
    }

    private boolean confirmOperation() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.confirmOperation");
        boolean confirmed = false;
        LocalizableText confirmButton = new LocalizableText(BaseTextBundle.getBundleName(), confirmButtons[this.operation]);
        LocalizableText selection = null;
        selection = this.showMessageBox(true, new BaseMessageTitle(confirmTitle[this.operation]), new BaseMessageText(confirmMsg[this.operation]), null, new LocalizableText[]{confirmButton, CommonMsgInterface.CANCEL_BUTTON});
        if (selection.equals(confirmButton)) {
            confirmed = true;
        }
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.confirmOperation - confirmed = " + confirmed);
        return confirmed;
    }

    private boolean checkChangeManagementEnabled() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.checkChangeManagementEnabled()");
        boolean enabled = true;
        try {
            this.myUU.ensureChangeManagementIsEnabled();
        }
        catch (HException e) {
            enabled = false;
            Object selection = null;
            LocalizableText localizableText = this.showMessageBox(true, new BaseMessageTitle(confirmTitle[this.operation]), new BaseMessageText("SSM01903"), null, null);
        }
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.checkChangeManagementEnabled() - enabled = " + enabled);
        return enabled;
    }

    private boolean isRsfAvailable() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.isRsfAvailable()");
        boolean available = this.myUU.isRsfAvailable();
        if (!available) {
            if (0 == this.operation) {
                Trace.trace(TRACE_MASKF, "-> ConsoleSingleStepMclTasklet.isRsfAvailable() - Retrieve");
                LocalizableText selection = null;
                selection = this.showMessageBox(true, new BaseMessageTitle(confirmTitle[this.operation]), new BaseMessageText("SSM01904"), null, null);
            } else if (1 == this.operation) {
                Trace.trace(TRACE_MASKF, "-> ConsoleSingleStepMclTasklet.isRsfAvailable() - Apply");
                LocalizableText continueButton = new LocalizableText(BaseTextBundle.getBundleName(), "updates.ssm.button.continue");
                LocalizableText selection = null;
                selection = this.showMessageBox(true, new BaseMessageTitle(confirmTitle[this.operation]), new BaseMessageText("SSM01905"), null, new LocalizableText[]{continueButton, CommonMsgInterface.CANCEL_BUTTON});
                if (selection.equals(continueButton)) {
                    available = true;
                }
            } else {
                available = true;
            }
        }
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.isRsfAvailable() - available = " + available);
        return available;
    }

    public boolean isCanceled() {
        Trace.trace(TRACE_MASKT, "<> ConsoleSingleStepMclTasklet.isCanceled() canceled = " + this.progressCanceled);
        return this.progressCanceled;
    }

    public void operationCompleted(SingleStepEvent e) {
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.operationCompleted()");
        int status = e.getCompletionStatus();
        LocalizableText msg = e.getMessage();
        Trace.trace(TRACE_MASKF, "-> ConsoleSingleStepMclTasklet.operationCompleted() - status, message: " + status + ", " + msg);
        CompletionReport rpt = new CompletionReport(null, CompletionReportCode.SUCCESS);
        rpt.setText(msg);
        if (1 != status && 3 != status) {
            rpt.setCompletionCode(CompletionReportCode.FAIL);
            rpt.setText(null);
            rpt.setData(e.getDetailsMessage());
        }
        if (3 != status && this.myUU.isShutdownPending()) {
            msg = new LocalizableText(BaseTextBundle.getBundleName(), "updates.ssm.progress.reboot");
            this.reportListener.intermediateReport(new StepReport(null, msg));
            ChangeMgmtInfo cmInfo = ChangeMgmtInfo.getChangeMgmtInfo();
            int saveOperation = 1;
            if (2 == this.operation) {
                saveOperation = 2;
            }
            cmInfo.setSstepOperation(saveOperation);
            cmInfo.setMultiPass(this.myUU.isApplyOrRejectMultiPass());
            RestartManager rm = RestartManager.getRestartManager();
            rm.addPostInit(RESTART_CLASS);
            this.myUU.performShutdown();
        }
        this.reportListener.completeReport(rpt);
        Trace.trace(TRACE_MASKT, "<- ConsoleSingleStepMclTasklet.operationCompleted()");
    }

    public void operationProgressing(SingleStepEvent e) {
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.operationProgressing()");
        this.reportListener.intermediateReport(new StepReport(null, e.getMessage()));
        if (e.getDuration() > 0) {
            this.reportListener.intermediateReport(new DurationReport(null, e.getDuration()));
        }
        Trace.trace(TRACE_MASKT, "<- ConsoleSingleStepMclTasklet.operationProgressing()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> ConsoleSingleStepMclTasklet.progressEnded()");
        Object object = this.progressGate;
        synchronized (object) {
            this.progressDismissed = true;
            Trace.trace(TRACE_MASKF, "   ConsoleSingleStepMclTasklet.progressEnded() - entering notifyAll()");
            this.progressGate.notifyAll();
            Trace.trace(TRACE_MASKF, "   ConsoleSingleStepMclTasklet.progressEnded() - leaving notifyAll()");
        }
        Trace.trace(TRACE_MASKT, "<- ConsoleSingleStepMclTasklet.progressEnded()");
    }

    public synchronized void progressCanceled(String id) {
        Trace.trace(TRACE_MASKT, "<> ConsoleSingleStepMclTasklet.progressCanceled()");
        this.progressCanceled = true;
    }

    public boolean isBusyDesired() {
        Trace.trace(TRACE_MASKT, "<> ConsoleSingleStepMclTasklet.isBusyDesired() - " + this.isBusyDesiredForMediaOperations);
        return this.isBusyDesiredForMediaOperations;
    }

    public LocalizableText getBusyMessage() {
        Trace.trace(TRACE_MASKT, "<> ConsoleSingleStepMclTasklet.getBusyMessage() -  returning [" + this.busyMessage + "]");
        return this.busyMessage;
    }

    public PanelTasklet getPanelTasklet() {
        Trace.trace(TRACE_MASKT, "<> ConsoleSingleStepMclTasklet.getPanelTasklet() -  returning ourself");
        return this;
    }
}

